/** @file   fighter.h
 * @brief   Declaraction of Fighter - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_FIGHTER_H
#define H_WWW_FIGHTER_H

#include "gameobject.h"

namespace WeWantWar {


/** @class  Fighter
 * @brief   Provides the interface for enemy aeroplanes.
 * @author  Tomi Lamminsaari
 *
 * 
 */
class Fighter : public GameObject
{
public:
  
	/** Constructor.
   * @param   aTypeName         The typename of this fighter. This literal
   *                            operates as the prefix to settings data.
   */
	Fighter( const std::string& aTypeName );

	/** Destructor
   */
	virtual ~Fighter();

private:
  Fighter( const Fighter& rO );
  Fighter& operator = ( const Fighter& rO );
public:

  /** Updates this fighter.
   */
  virtual void update();
  
  /** Kills this fighter.
   */
  virtual void kill();
  
  /** Makes the sounds
   * @param     id                ID of the sound we should make.
   */
  virtual void makeSound( GameObject::SoundID id ) const;
  
  /** Handles the bullet hits
   * @param     pB                Pointer to bullet that hit us
   * @return    <code>true</code> if the bullet hits us
   */
  virtual bool hitByBullet( Bullet* pB );
  
  /** The redraw - method
   * @param     pQueue            Pointer to redraw queue
   */
  virtual void redraw( RedrawQueue* pQueue );

  /** Reimplemented move-method since these fighters don't collide with
   * map tiles.
   * @param     rMoveVec          The movement vector
   */
  virtual bool move( const eng2d::Vec2D& rMoveVec );
  
  ///
  /// Getter methods
  /// ==============
  
  /** Tells if we're reloading.
   * @return    <code>true</code> if we're reloading
   */
  virtual bool reloading() const;
  
  /** Returns the type of this object.
   * @return    ObjectID::TYPE_FIGHTER
   */
  virtual ObjectID::Type objectType() const;
  


protected:

  static const int KGun1Nose = 0;
  static const int KGun2Nose = 1;
  
  /** Initializes the fighter. The @c m_fighterType member should have
   * information about the type of this fighter.
   */
  int initFighter( const std::string& aPrefix );
  
  /** Makes this fighter to shoot.
   */
  void shoot();


protected:  // members

  /** Velocity */
  float iVelocity;
  
  /** Uid of the graphics. */
  int iGraphicUid;
  
  /** Uid of the shadow graphics */
  int iShadowUid;
  
  /** The bullet type. */
  Bullet::TType iBulletType;

  /** THe soundsource */
  eng2d::SoundSource* m_pSSource;
  
  /** Attacking sound index. */
  int iAttackSound;
};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: fighter.h,v $
 * Revision 1.2  2006/03/16 21:06:57  lamminsa
 * Code cleanup.
 *
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:56+02  lamminsa
 * Initial revision
 *
 */
 
